<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
 error_reporting(E_ALL);
require __DIR__ . '/vendor/autoload.php';
die('aa');
use Aws\Sts\StsClient;
use Aws\DynamoDb\DynamoDbClient;
use Aws\Exception\AwsException;

// Create STS client (uses default credentials from EC2 IAM Role or ~/.aws/credentials)
$stsClient = new StsClient([
    'region'  => 'ap-south-1',  // adjust region
    'version' => 'latest'
]);

$roleArn = "arn:aws:iam::334835636290:role/quiklrn_lambda"; // replace with your IAM role ARN
$sessionName = "DynamoDBRoleSession";

try {
    // Assume the IAM role
    $result = $stsClient->assumeRole([
        'RoleArn'         => $roleArn,
        'RoleSessionName' => $sessionName,
    ]);

    // Extract temporary credentials
    $creds = $result['Credentials'];

    $dynamodbClient = new DynamoDbClient([
        'version'     => 'latest',
        'region'      => 'ap-south-1',
        'credentials' => [
            'key'    => $creds['AccessKeyId'],
            'secret' => $creds['SecretAccessKey'],
            'token'  => $creds['SessionToken']
        ]
    ]);

    echo "✅ DynamoDB client initialized with assumed role.\n";

    // Example: list tables
    $tables = $dynamodbClient->listTables();
    print_r($tables['TableNames']);

} catch (AwsException $e) {
    echo "❌ Error assuming role: " . $e->getMessage() . "\n";
}
